<?php

class CardOrderInfo
{
    private $order;
    public function __construct($order_id)
    {
        $this->order = wc_get_order($order_id);
    }

    public function getParam()
    {

        $shipping = $this->order->get_address('shipping');
        $billing = $this->order->get_address('billing');

        $items = [];
        foreach ($this->order->get_items() as $item_id => $item) {
            $product = $item->get_product();
            $dataItem = [
                "name" => $item->get_name(),
                "merchantItemId" => $product->get_id(),
                "quantity" => $item->get_quantity(),
                "type" => "product",
                "sku" => $product->get_sku(),
                "currency" => get_woocommerce_currency(),
                "description" => $product->get_description(),
                "originalPrice" => wc_format_decimal($product->get_regular_price(), 2),
                "price" => wc_format_decimal($product->get_price(), 2),
                "totalAmount" => wc_format_decimal($item->get_total(), 2),
                "taxAmount" => wc_format_decimal($item->get_subtotal_tax(), 2),
                "totalTaxAmount" => wc_format_decimal($item->get_total_tax(), 2),
                "discount" => wc_format_decimal($item->get_subtotal() - $item->get_total(), 2),
                "shippingMethod" => $this->order->get_shipping_method(),
                "quantityUnit" => "COUNT",
                "productUrl" => get_permalink($product->get_id()),
             
                "totalDiscountAmount" => wc_format_decimal($item->get_subtotal() - $item->get_total(), 2),
                "recipient" => [
                    //"salutation" => "", // Custom field
                    "firstName" => $shipping['first_name'],
                    //"middleName" => "", // Custom field
                    "lastName" => $shipping['last_name'],
                    // "apartment" => $shipping['address_2'],
                    // "street" => $shipping['address_1'],
                    "address" => $shipping['address_1'] . ', ' . $shipping['address_2'],
                    "city" => $shipping['city'],
                    "state" => $shipping['state'],
                    "postcode" => $shipping['postcode'],
                    "country" => $shipping['country'],
                    "phone" => $billing['phone'],
                    "email" => $billing['email'],
                ],
                "deliveryDate" => "", // Estimated or scheduled delivery date if available
            ];

            $image = wp_get_attachment_url($product->get_image_id());
            if ($image) {
               $dataItem['imageUrl'] = $image;
            }


            $items[] = $dataItem;
        }

        $payments[] = [
            "name" => $this->order->get_payment_method_title(),
            //"type" => "GUFTCARD", // Adjust depending on your logic or method
            "amount" => wc_format_decimal($this->order->get_total(), 2),
            "currency" => get_woocommerce_currency(),
            //"status" => $this->order->get_status(),
            "brand" => $this->order->get_payment_method(), // e.g., 'stripe', 'paypal'
            "primary" => true
        ];

        $data = [

            "shipping" => [
                "street1" => $shipping['address_1'],
                "street2" => $shipping['address_2'],
                "city" => $shipping['city'],
                "state" => $shipping['state'],
                "postcode" => $shipping['postcode'],
                "country" => $shipping['country'],
                "method" => $this->order->get_shipping_method(),
                "cost" => wc_format_decimal($this->order->get_shipping_total(), 2),
                "comment" => $this->order->get_customer_note(),

                "normalized" => false,
                "validationStatus" => "VALID",

                "companyName" => $shipping['company'],
                "phone" => $billing['phone'],
                "email" => $billing['email'],
            ],
            "cart" => [
                "items" => $items,
                "payments" => $payments
            ],

        ];

        return $data;
    }
}
